unit Charedit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Pyrolab, StdCtrls, Buttons, ExtCtrls, Menus, charactr,
  Imprtdlg;

type

  TCharEditor = class(TForm)
    MainMenu1: TMainMenu;
    OpenListDialog: TOpenDialog;
    SaveListDialog: TSaveDialog;
    CharacterName: TEdit;
    Label1: TLabel;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    New1: TMenuItem;
    AddBitmapFrame1: TMenuItem;
    MassImportBitmaps1: TMenuItem;
    Bevel1: TBevel;
    FrameDisplay: TImage;
    Label3: TLabel;
    FrameNumber: TPyroLabel;
    NextCharButton: TButton;
    PrevCharButton: TButton;
    NewButton: TButton;
    Label2: TLabel;
    FrameCount: TPyroLabel;
    OpenFrameDialog: TOpenDialog;
    TopFrameButton: TBitBtn;
    BottomFrameButton: TBitBtn;
    PrevFrameButton: TBitBtn;
    NextFrameButton: TBitBtn;
    E1: TMenuItem;
    D1: TMenuItem;
    D2: TMenuItem;
    ColorCombo: TComboBox;
    Label4: TLabel;
    FastAnimMode: TCheckBox;
    Label5: TLabel;
    CurrentCharacter: TPyroLabel;
    TotalCharacters: TPyroLabel;
    Bevel2: TBevel;
    Label6: TLabel;
    ImportBitmapsDlg: TPyroImportDialog;
    procedure Exit1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure PrevFrameButtonClick(Sender: TObject);
    procedure NextFrameButtonClick(Sender: TObject);
    procedure NextCharButtonClick(Sender: TObject);
    procedure PrevCharButtonClick(Sender: TObject);
    procedure SaveCharacterList(Sender: TObject);
    procedure UpdateFrame;
    procedure UpdateCharacter;
    procedure controlswitch(state:Boolean);
    procedure cleanup(Sender: TObject; var CanClose: Boolean);
    procedure addnewframe(Sender: TObject);
    procedure ChangeName(Sender: TObject);
    procedure NewButtonClick(Sender: TObject);
    procedure MassImport(Sender: TObject);
    procedure OpenFile(Sender: TObject);
    procedure SaveFileAs(Sender: TObject);
    procedure BottomFrameButtonClick(Sender: TObject);
    procedure TopFrameButtonClick(Sender: TObject);
    procedure D1Click(Sender: TObject);
    procedure D2Click(Sender: TObject);
    procedure doinit(Sender: TObject);
    procedure AddToList(const color:String);
    procedure changetranscolor(Sender: TObject);
    procedure FastAnimModeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CharEditor: TCharEditor;
  charlist:TMapCharacterList;
  charindex:Integer;
  loadedfile:String;
  datachanged:boolean;

implementation

uses
    Frameld;

{$R *.DFM}

procedure TCharEditor.cleanup(Sender: TObject; var CanClose: Boolean);
var
dlg:Integer;
begin
     if Assigned(charlist) and datachanged then begin
        if charlist.count>0 then begin
           dlg:=Application.Messagebox('Save current character list?','Save it?',mb_yesnocancel);
           if dlg=IDYES then
              SaveCharacterList(Sender);
           if dlg=IDCANCEL then begin
                CanClose:=False;
                Exit;
           end;
        end;
     end;
end;

procedure TCharEditor.Exit1Click(Sender: TObject);
begin
     Application.Terminate;
end;

procedure TCharEditor.New1Click(Sender: TObject);
var
dlg:Integer;
char:TMapCharacter;
begin
     if Assigned(charlist) then begin
        if charlist.count>0 then begin
           dlg:=Application.Messagebox('Save current Character List first?','Warning',mb_YesNoCancel);
           if dlg=IDYES then
              SaveCharacterList(Sender)
           else if dlg=IDCANCEL then
                Exit;
           charlist.free
        end;
     end;
     charlist:=TMapCharacterList.create;
     char:=TMapCharacter.Create(nil);
     char.name:='New Character';
     charlist.add(char);
     UpdateFrame;
     UpdateCharacter;
     controlswitch(true);
     datachanged:=true;
end;

procedure TCharEditor.PrevFrameButtonClick(Sender: TObject);
var
char:TMapCharacter;
begin
     char:=TMapCharacter(charlist.items[charindex]);
     char.frame:=char.frame-1;
     UpdateFrame;
end;

procedure TCharEditor.NextFrameButtonClick(Sender: TObject);
var
char:TMapCharacter;
begin
     char:=TMapCharacter(charlist.items[charindex]);
     char.frame:=char.frame+1;
     UpdateFrame;
end;

procedure TCharEditor.UpdateFrame;
var
char:TMapCharacter;
begin
     char:=TMapCharacter(charlist.items[charindex]);
     if char.framestore.count=0 then
        FrameNumber.Number:=0
     else
         FrameNumber.Number:=char.frame+1;
     FrameCount.Number:=char.framestore.count;
     if char.framestore.count>0 then
        FrameDisplay.Picture.Bitmap:=TBitMap(char.Framestore.items[char.frame])
     else
         FrameDisplay.Picture:=nil;
end;

procedure TCharEditor.NextCharButtonClick(Sender: TObject);
begin
     if charindex+1<=charlist.count-1 then begin
        charindex:=charindex+1;
        UpdateCharacter;
     end
     else MessageBeep($ffff);
end;

procedure TCharEditor.PrevCharButtonClick(Sender: TObject);
begin
     if charindex-1>=0 then begin
        charindex:=charindex-1;
        UpdateCharacter;
     end
     else MessageBeep($ffff);
end;

procedure TCharEditor.UpdateCharacter;
var
char:TMapCharacter;
a:Integer;
begin
     if charlist.count>0 then begin
        char:=TMapCharacter(charlist.items[charindex]);
        CharacterName.Text:=char.name;
        FastAnimMode.Checked:=char.FastMode;
        currentcharacter.number:=charindex+1;
        totalcharacters.number:=charlist.count;

        for a:=0 to ColorCombo.Items.count-1 do begin
            if ColorCombo.items[a]=ColorToString(char.Transcolor) then begin
               ColorCombo.Itemindex:=a;
               Break;
            end;
        end;

        UpdateFrame;
     end;
end;


procedure TCharEditor.controlswitch(state:Boolean);
var
a:Integer;
begin
     CharacterName.enabled:=state;
     PrevFrameButton.enabled:=state;
     NextFrameButton.enabled:=state;
     TopFrameButton.enabled:=state;
     BottomFrameButton.enabled:=state;
     NextCharButton.enabled:=state;
     PrevCharButton.enabled:=state;
     AddBitmapFrame1.enabled:=state;
     MassImportBitmaps1.enabled:=state;
     Save1.enabled:=state;
     SaveAs1.enabled:=state;
     ColorCombo.enabled:=state;
     fastanimmode.enabled:=state;
end;

procedure TCharEditor.SaveCharacterList(Sender: TObject);
begin
     if Assigned(charlist) then begin
        if loadedfile='' then begin
           SaveFileAs(Sender);
           exit;
        end;
        try
           charlist.savetofile(loadedfile);
           datachanged:=false;
        except
        end;
     end;
end;

procedure TCharEditor.SaveFileAs(Sender: TObject);
begin
     if SaveListDialog.execute then begin
        try
           charlist.savetofile(savelistdialog.filename);
           loadedfile:=savelistdialog.filename;
           datachanged:=false;
        except
        end;
     end;
end;

procedure TCharEditor.OpenFile(Sender: TObject);
var
dlg:Integer;
cl:TMapCharacterList;
begin
     if openlistdialog.execute then begin
        if Assigned(charlist) and datachanged=true then begin
           dlg:=Application.Messagebox('Save current character list first?','Huh?',mb_yesnocancel);
           if dlg=IDYES then
              SaveCharacterList(Sender)
           else if dlg=IDCANCEL then
                Exit;
        end;
        try
           cl:=TMapCharacterList.Create;
           cl.loadfromfile(openlistdialog.filename);
           loadedfile:=openlistdialog.filename;
           datachanged:=false;
           charlist.free;
           charlist:=cl;
           charindex:=0;
           controlswitch(true);
           UpdateCharacter;
           UpdateFrame;
        except
              on E:EReadError do Application.ShowException(E);
        end;
     end;
end;

procedure TCharEditor.addnewframe(Sender: TObject);
var
char:TMapCharacter;
bm:TBitMap;
frameplace:Integer;
begin
     char:=TMapCharacter(charlist.items[charindex]);

     if OpenFrameDialog.execute then begin
        If FileExists(OpenFrameDialog.filename) then begin
           try
              frameplace:=PlaceFrame.Showmodal;
              if frameplace=mrCancel then
                 exit;
              bm:=TBitMap.create;
              bm.loadfromfile(openframedialog.filename);
              {Abort = Append to frame list }
              if frameplace=mrAbort then
                 char.framestore.add(bm);
              {Retry = Insert before current }
              if frameplace=mrRetry then
                 char.framestore.insert(char.frame,bm);
              {Ignore = Replace current }
              if frameplace=mrIgnore then begin
                 {Decided to be paranoid and not directly play with pointers..}
                 if char.framestore.count>0 then begin
                    TBitmap(char.framestore.items[char.frame]).free;
                    char.framestore.Delete(char.frame);
                 end;
                 char.framestore.insert(char.frame,bm);
              end;
              datachanged:=true;
           except
           end;
        end;
        UpdateFrame;
     end;
end;

procedure TCharEditor.ChangeName(Sender: TObject);
begin
     TMapCharacter(charlist.items[charindex]).name:=CharacterName.text;
     datachanged:=true;
end;

procedure TCharEditor.NewButtonClick(Sender: TObject);
var
char:TMapCharacter;
begin
     if not(Assigned(charlist)) then begin
        New1Click(Sender);
        Exit;
     end;
     char:=TMapCharacter.create(nil);
     char.name:='New Character';
     charindex:=charlist.add(char);
     UpdateCharacter;
     UpdateFrame;
     datachangeD:=true;
end;

procedure TCharEditor.MassImport(Sender: TObject);
var
char:TMapCharacter;
bm:TBitMap;
a,place,cframe:Integer;
files:TStringList;
begin
     files:=ImportBitmapsDlg.Execute;
     if files<>nil then begin
        try
           place:=placeframe.showmodal;
           if place<>IDCANCEL then begin

              char:=TMapCharacter(charlist.items[charindex]);
              cframe:=char.frame;
              for a:=0 to files.count-1 do begin
               bm:=TBitMap.Create;
               bm.loadfromfile(files.strings[a]);
               {ABORT = Append to frame list}
               if place=IDABORT then
                  char.framestore.add(bm);
               {RETRY = Insert }
               if place=IDRETRY then begin
                  char.framestore.insert(cframe,bm);
                  Inc(cframe);
               end;
               if place=IDIGNORE then begin
                  {Decided to be paranoid and not directly play with pointers..}
                  if char.framestore.count>0 then begin
                     TBitmap(char.framestore.items[cframe]).free;
                     char.framestore.Delete(cframe);
                  end;
                  char.framestore.insert(cframe,bm);
               end;
              end;
              char.frame:=0;
              chareditor.updatecharacter;
           end;

        finally
               files.free;
        end;
     end;
end;

procedure TCharEditor.BottomFrameButtonClick(Sender: TObject);
var
char:TMapCharacter;
begin
     char:=TMapCharacter(charlist.items[charindex]);
     if Assigned(charlist) then begin
        char.frame:=char.framestore.count-1;
        UpdateCharacter;
     end;
end;

procedure TCharEditor.TopFrameButtonClick(Sender: TObject);
begin
     if assigned(charlist) then begin
        TMapCharacter(charlist.items[charindex]).frame:=0;
        UpdateCharacter;
     end;
end;

procedure TCharEditor.D1Click(Sender: TObject);
var
char:TMapCharacter;
begin
     if Assigned(charlist) then begin
        char:=TMapCharacter(charlist.items[charindex]);
        if (charlist.count>0) and (char.framestore.count>0) then begin
           TBitmap(char.framestore.items[char.frame]).free;
           char.framestore.delete(char.frame);
           if char.FastMode then begin
              TBitMap(char.maskstore.items[char.frame]).free;
              char.maskstore.delete(char.frame);
           end;

           if char.frame>0 then
              char.frame:=char.frame-1
           else
               char.frame:=0;

           UpdateCharacter;
        end;
     end;
end;

procedure TCharEditor.D2Click(Sender: TObject);
begin
     if assigned(charlist) then
        if charlist.count>0 then begin
           TMapCharacter(charlist.items[charindex]).free;
           charlist.delete(charindex);
           if charlist.count=0 then
              NewButtonClick(Sender);
           UpdateCharacter;
        end;

end;

procedure TCharEditor.doinit(Sender: TObject);
begin
     GetColorValues(AddToList);
end;

procedure TCharEditor.AddToList(const color:String);
begin
     ColorCombo.Items.Add(color);
end;

procedure TCharEditor.changetranscolor(Sender: TObject);
begin
     TMapCharacter(charlist.items[charindex]).transcolor:=StringToColor(ColorCombo.items[ColorCombo.Itemindex]);
end;

procedure TCharEditor.FastAnimModeClick(Sender: TObject);
var
char:TMapCharacter;
begin
     char:=TMapCharacter(charlist.items[charindex]);
     Screen.Cursor:=crHourGlass;
     char.Fastmode:=true;
     Screen.cursor:=crDefault;
end;

end.
